{include file="left.tpl"}

<script src="../modules/editors/tinymce/tinymce.min.js"></script>
<script>
	jQuery(document).ready(function($)
	{
		init_tinymce('signature', 'lite', '{file_manager_theme}', '', '');

		$('#edit_user_avatar_form').submit(function(event)
		{
			NProgress.start();

			event.preventDefault();

			var data = new FormData($('#edit_user_avatar_form')[0]);

			$.ajax({
				type: 'POST',
				url: '../ajax/actions_a.php',
				data: data,
				contentType: false,
				processData: false,
			}).done(function (html){
				NProgress.done();

				$('#edit_user_avatar_result').html(html);
				$('#edit_user_avatar_form')[0].reset();
			});
		});
	});

	function on_im(val)
	{
		NProgress.start();

		$.ajax({
			type: 'POST',
			url: '../ajax/actions_a.php',
			data: 'phpaction=1&on_im=1&token='+$('#token').val()+'&val='+val,
			dataType: 'json',
			success: function(result)
			{
				$('#on_im_1').removeClass('active');
				$('#on_im_2').removeClass('active');

				$('#on_im_'+val).addClass('active');

				NProgress.done();

				if(result.status == 1)
					setTimeout(show_ok, 500);
				else
					setTimeout(show_error, 500);
			}
		});
	}

	function on_ip_protect(val)
	{
		NProgress.start();

		$.ajax({
			type: 'POST',
			url: '../ajax/actions_a.php',
			data: 'phpaction=1&on_ip_protect=1&token='+$('#token').val()+'&val='+val,
			dataType: "json",
			success: function(result)
			{
				$('#on_ip_protect_1').removeClass('active');
				$('#on_ip_protect_2').removeClass('active');

				$('#on_ip_protect_'+val).addClass('active');

				NProgress.done();

				if(result.status == 1)
					setTimeout(show_ok, 500);
				else
					setTimeout(show_error, 500);
			}
		});
	}

	function get_referrals()
	{
		$.ajax({
			type: 'POST',
			url: '../templates/SquareLine/php/profile_referals.php',
			data: 'token='+$('#token').val(),
			success: function(data)
			{
				$('#referral_info').show();
				$('#referral_info .header').html('Список рефералов');
				$('#referral_info .block-content').html(data);
			}
		});
	}

	function get_ref_profit()
	{
		$.ajax({
			type: 'POST',
			url: '../templates/SquareLine/php/profile_profit.php',
			data: 'token='+$('#token').val(),
			success: function(data)
			{
				$('#referral_info').show();
				$('#referral_info .header').html('Информация о зачислениях');
				$('#referral_info .block-content').html(data);
			}
		});
	}
</script>

<div class="content float-right">
	<div class="block">
		<div class="header">Редактирование профиля</div>
		<div class="block-content">
			<div class="form-input">
				<label for="user_login">Логин</label>
				<input type="text" id="user_login" maxlength="15" autocomplete="off" value="{login}" placeholder="Введите логин">
			</div>
			<div class="message-send">
				<div class="btn green float-left" onclick="edit_user_login()">Сохранить</div>
				<div class="float-right" id="edit_user_login_result"></div>
			</div>

			<div class="clear"></div>

			<? if($user->password == 'none'){ ?>
				<div class="form-input">
					<label for="first_user_password">Пароль</label>
					<input type="password" id="first_user_password" maxlength="15" autocomplete="off" placeholder="Введите новый пароль"><br>
				</div>
				<div class="form-input">
					<label for="first_user_password2">Пароль еще раз</label>
					<input type="password" id="first_user_password2" maxlength="15" autocomplete="off" placeholder="Повторите новый пароль">
				</div>
				<div class="message-send">
					<div class="btn green float-left" onclick="edit_first_user_password()">Сохранить</div>
					<div class="float-right" id="edit_first_user_password_result"></div>
				</div>
			<? } else { ?>
				<div class="form-input">
					<label for="user_old_password">Текущий пароль</label>
					<input type="password" id="user_old_password" maxlength="15" autocomplete="off" placeholder="Введите текущий пароль"><br>
				</div>
				<div class="form-input">
					<label for="user_password">Новый пароль</label>
					<input type="password" id="user_password" maxlength="15" autocomplete="off" placeholder="Повторите новый пароль">
				</div>
				<div class="form-input">
					<label for="user_password2">Новый пароль еще раз</label>
					<input type="password" id="user_password2" maxlength="15" autocomplete="off" placeholder="Повторите новый пароль">
				</div>
				<div class="message-send">
					<div class="btn green float-left" onclick="edit_user_password()">Сохранить</div>
				</div>
				<div class="float-right" id="edit_user_password_result"></div>
			<? } ?>

			<div class="clear"></div>

			<div class="form-input">
				<label for="user_name">Имя</label>
				<input type="text" id="user_name" maxlength="30" autocomplete="off" value="{name}" placeholder="Введите имя">
			</div>
			<div class="message-send">
				<div class="btn green float-left" onclick="edit_user_name()">Сохранить</div>
				<div class="float-right" id="edit_user_name_result"></div>
			</div>

			<div class="clear"></div>

			<div class="form-input">
				<label for="user_nick">Ник на сервере</label>
				<input type="text" id="user_nick" maxlength="30" autocomplete="off" value="{nick}" placeholder="Введите ник">
			</div>
			<div class="message-send">
				<div class="btn green float-left" onclick="edit_user_nick()">Сохранить</div>
				<div class="float-right" id="edit_user_nick_result"></div>
			</div>

			<div class="clear"></div>

			<div class="form-input">
				<label for="user_steam_id">SteamID</label>
				<input type="text" id="user_steam_id" maxlength="32" autocomplete="off" value="{steam_id}" placeholder="Введите SteamID">
			</div>
			<div class="message-send">
				<div class="btn green float-left" onclick="edit_user_steam_id()">Сохранить</div>
				<div class="float-right" id="edit_user_steam_id_result"></div>
			</div>

			<div class="clear"></div>

			<div class="form-input">
				<label>Дата рождения</label>
				<select class="m-b-5" id="birth_day">{birth_day}</select>
				<select class="m-b-5" id="birth_month">{birth_month}</select>
				<select id="birth_year">{birth_year}</select>
			</div>
			<div class="message-send">
				<div class="btn green float-left" onclick="edit_user_birth()">Сохранить</div>
				<div class="float-right" id="edit_user_birth_result"></div>
			</div>

			<div class="clear"></div>

			<div class="form-input">
				<label for="user_skype">Skype</label>
				<input type="text" id="user_skype" maxlength="32" autocomplete="off" value="{skype}" placeholder="Введите логин skype">
			</div>
			<div class="message-send">
				<div class="btn green float-left" onclick="edit_user_skype()">Сохранить</div>
				<div class="float-right" id="edit_user_skype_result"></div>
			</div>

			<div class="clear"></div>

			<div class="form-input">
				<label for="user_telegram">Телеграм</label>
				<input type="text" id="user_telegram" maxlength="50" autocomplete="off" value="{telegram}" placeholder="Введите логин телеграм">
			</div>
			<div class="message-send">
				<div class="btn green float-left" onclick="edit_user_telegram()">Сохранить</div>
				<div class="float-right" id="edit_user_telegram_result"></div>
			</div>

			<div class="clear"></div>

			<? if($auth_api->vk_api == '2'){ ?>
				<div class="form-input">
					<label for="user_vk">Аккаунт Вконтакте</label>
					<input type="text" id="user_vk" maxlength="30" autocomplete="off" value="{vk}" placeholder="Введите id вконтакте">
				</div>
				<div class="message-send">
					<div class="btn green float-left" onclick="edit_user_vk()">Сохранить</div>
					<div class="float-right" id="edit_user_vk_result"></div>
				</div>
			<? } else { ?>
				<? if($user->vk_api == '0'){ ?>
					<div class="form-input">
						<label>Аккаунт Вконтакте</label>
					</div>
					<div class="bs-callout bs-callout-info bs-mini-info m-t-5 m-b-5"><p>Прикрепить профиль к аккаунту VK. Если Ваш профиль будет прикреплен к аккаунту VK, то Вы сможете авторизовываться на сайте в один клик по кнопке "Войти через VK".</p></div>
					<div class="message-send">
						<a id="vk_link" href="#" class="float-left"><u>Прикрепить профиль к VK</u></a>
						<script>attach_user_vk()</script>
					</div>
				<? } else { ?>
					<div class="form-input">
						<label>Аккаунт Вконтакте</label>
					</div>
					<div class="chat-message">
						<div class="chat-data">
							<div class="chat-user-avatar float-left">
								<a target="_blank" href="http://vk.com/{vk}" id="vk_user"><img src="../files/avatars/no_avatar.jpg"></a>
							</div>
							<div class="chat-text">
								<p><b>Ваш профиль прикреплен к данному аккаунту</b></p>
								<p class="m-t-5"><a href="#" onclick="unset_vk(); return false">Открепить профиль</a></p>
								<p class="m-t-5" id="unset_vk_result"></p>
							</div>
						</div>
						<div class="clear"></div>
					</div>
					<script>
						$.getJSON('https://api.vk.com/method/users.get?uids={vk_api}&fields=photo_50&callback=?', function(resp)
						{
							$('#vk_user img').attr('src', resp.response[0].photo_50);
							$('#vk_user img').attr('alt', resp.response[0].first_name+' '+resp.response[0].last_name);
							$('#vk_user span').append(resp.response[0].first_name+' '+resp.response[0].last_name);
						});
					</script>
				<? } ?>

				{conf_mess}
			<? } ?>
			<div class="clear"></div>

			<? if($auth_api->steam_api != '2'){ ?>
				<div class="form-input">
					<label>Аккаунт Steam</label>
				</div>
				<? if('{steam_api}' == '0'){ ?>
					<div class="bs-callout bs-callout-info bs-mini-info m-t-5 m-b-5"><p>Прикрепить профиль к аккаунту Steam. Если Ваш профиль будет прикреплен к аккаунту Steam, то Вы сможете авторизовываться на сайте в один клик по кнопке "Войти через Steam".</p></div>
					<div class="message-send m-b-25">
						<a id="steam_link" href="#" class="float-left"><u>Прикрепить профиль к Steam</u></a>
						<script>attach_user_steam()</script>
					</div>
				<? } else { ?>
					<div class="chat-message">
						<div class="chat-data">
							<div class="chat-user-avatar float-left">
								<a target="_blank" href="http://steamcommunity.com/profiles/{steam_api}/" id="steam_user"><img src="../files/avatars/no_avatar.jpg"></a>
							</div>
							<div class="chat-text">
								<p><b>Ваш профиль прикреплен к данному аккаунту</b></p>
								<p class="m-t-5"><a href="#" onclick="unset_steam(); return false">Открепить профиль</a></p>
								<p class="m-t-5" id="unset_steam_result"></p>
							</div>
						</div>
						<div class="clear"></div>
					</div>
					<script>get_user_steam_info('{steam_api}')</script>
				<? } ?>

				{conf_mess}
			<? } ?>
			<div class="clear"></div>

			<div class="space"></div>

			<div class="form-input">
				<label>Аватарка</label>
			</div>
			<div class="upload-image">
				<img id="avatar" src="../{avatar}" class="float-left">
				<form enctype="multipart/form-data" action="ajax/actions_a.php" method="post" id="edit_user_avatar_form" class="float-right">
					<input type="hidden" id="token" name="token" value="{token}">
					<input type="hidden" id="edit_user_avatar" name="edit_user_avatar" value="1">
					<input type="hidden" id="phpaction" name="phpaction" value="1">
					<input class="imginput" type="file" id="user_avatar" accept="image/*" name="user_avatar">
					<div class="space"></div>
					<div class="btn float-left" onclick="$('#edit_user_avatar_form').submit()">Загрузить</div>
					<div id="edit_user_avatar_result" class="float-right"></div>
				</form>
			</div>

			<div class="clear"></div>

			<div class="form-input">
				<label>Личные сообщения могут писать</label>
			</div>
			<div class="message-send m-t-5">
				<label class="btn red float-left m-r-5 {act}" onclick="on_im(1)" id="on_im_1"><input type="radio">Все пользователи</label>
				<label class="btn red float-left {act2}" onclick="on_im(2)" id="on_im_2"><input type="radio">Только друзья</label>
			</div>

			<div class="clear"></div>

			<div class="form-input">
				<label>Привязка cookies к ip адресу</label>
			</div>
			<div class="message-send m-t-5">
				<label class="btn red float-left m-r-5 {ipp_act}" onclick="on_ip_protect(1)" id="on_ip_protect_1"><input type="radio">Включить</label>
				<label class="btn red float-left {ipp_act2}" onclick="on_ip_protect(2)" id="on_ip_protect_2"><input type="radio">Выключить</label>
			</div>

			<div class="clear"></div>

			<div class="form-input">
				<label>Подпись</label>
				<textarea id="signature" rows="5">{signature}</textarea>
			</div>
			<div class="message-send">
				<div class="btn green float-left" onclick="edit_signature()">Сохранить</div>
				<div class="float-right" id="edit_signature_result"></div>
			</div>

			<div class="clear"></div>

			<? if('{referral_program}' == '1') { ?>
				<div class="form-input">
					<label>Реферальная программа</label>
					<div class="bs-callout bs-callout-info bs-mini-info m-t-5 m-b-5">
						<p>Пользователи, зашедшие на сайт по данной ссылке и зарегистрированные на нем, будут являться Вашими рефералами. При пополнении своего баланса рефералом, Вы будете получать на Ваш баланс {referral_percent}% от суммы его пополнения.</p>
						<p class="m-t-5"><b>Ваша уникальная ссылка</b>: <u>{referral_link}</u></p>
					</div>
					<div class="message-send m-t-5">
						<div class="btn float-left m-r-5" onclick="get_referrals()">Мои рефералы</div>
						<div class="btn float-left" onclick="get_ref_profit()">Моя прибыль</div>
					</div>
				</div>

				<div class="clear"></div>
			<? } ?>
		</div>
	</div>
	<div class="block disp-n" id="referral_info">
		<div class="header"></div>
		<div class="block-content">
			
		</div>
	</div>
</div>